/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.block;

import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.rechiseled.block.BlockSpecification;
import com.supermartijn642.rechiseled.block.RechiseledBlock;
import com.supermartijn642.rechiseled.block.RechiseledBlockType;
import com.supermartijn642.rechiseled.data.RechiseledBlockStateGenerator;
import com.supermartijn642.rechiseled.data.RechiseledBlockTagsGenerator;
import com.supermartijn642.rechiseled.data.RechiseledChiselingRecipeProvider;
import com.supermartijn642.rechiseled.data.RechiseledConnectingBlockModelProvider;
import com.supermartijn642.rechiseled.data.RechiseledLanguageGenerator;
import com.supermartijn642.rechiseled.data.RechiseledLootTableGenerator;
import com.supermartijn642.rechiseled.texture.TextureType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class RechiseledBlockBuilder {
    private final String namespace;
    private final String identifier;
    private Supplier<BlockProperties> properties;
    private List<Consumer<BlockProperties>> propertiesConfigurers = new ArrayList<Consumer<BlockProperties>>();
    private BlockSpecification specification = BlockSpecification.BASIC;
    private boolean hasRegularVariant = true;
    private boolean hasConnectingVariant = true;
    private Supplier<Block> customRegularVariant;
    private Supplier<Block> customConnectingVariant;
    private Set<ResourceLocation> recipes = new HashSet<ResourceLocation>();
    private CreativeModeTab itemGroup;
    private Set<ResourceLocation> tags = new HashSet<ResourceLocation>();
    private Supplier<Block> tagsFromBlock;
    private TextureType regularTextureType = TextureType.NON_CONNECTING;
    private TextureType connectingTextureType = TextureType.CONNECTING;
    private String translation;

    RechiseledBlockBuilder(String namespace, String identifier) {
        this.namespace = namespace;
        this.identifier = identifier;
    }

    public RechiseledBlockBuilder properties(BlockProperties properties) {
        this.properties = () -> properties;
        this.propertiesConfigurers.clear();
        return this;
    }

    public RechiseledBlockBuilder copyProperties(Supplier<Block> block) {
        this.properties = () -> BlockProperties.copy((Block)((Block)block.get()));
        this.propertiesConfigurers.clear();
        return this;
    }

    public RechiseledBlockBuilder properties(Consumer<BlockProperties> configurer) {
        if (this.properties == null) {
            throw new RuntimeException("Properties cannot be null!");
        }
        this.propertiesConfigurers.add(configurer);
        return this;
    }

    public RechiseledBlockBuilder itemGroup(CreativeModeTab group) {
        this.itemGroup = group;
        return this;
    }

    public RechiseledBlockBuilder specification(BlockSpecification specification) {
        this.specification = specification;
        return this;
    }

    public RechiseledBlockBuilder noRegularVariant() {
        this.hasRegularVariant = false;
        return this;
    }

    public RechiseledBlockBuilder noConnectingVariant() {
        this.hasConnectingVariant = false;
        return this;
    }

    public RechiseledBlockBuilder regularVariant(Supplier<Block> blockSupplier) {
        this.customRegularVariant = blockSupplier;
        this.hasRegularVariant = false;
        return this;
    }

    public RechiseledBlockBuilder connectingVariant(Supplier<Block> blockSupplier) {
        this.customConnectingVariant = blockSupplier;
        this.hasConnectingVariant = false;
        return this;
    }

    public RechiseledBlockBuilder recipes(ResourceLocation location, ResourceLocation ... locations) {
        this.recipes.add(location);
        this.recipes.addAll(Arrays.asList(locations));
        return this;
    }

    public RechiseledBlockBuilder blockTag(String namespace, String identifier) {
        this.tags.add(new ResourceLocation(namespace, identifier));
        return this;
    }

    public RechiseledBlockBuilder blockTagsFrom(Supplier<Block> blockSupplier) {
        this.tagsFromBlock = blockSupplier;
        return this;
    }

    public RechiseledBlockBuilder regularVariantTextureType(TextureType type) {
        this.regularTextureType = type;
        return this;
    }

    public RechiseledBlockBuilder connectingVariantTextureType(TextureType type) {
        this.connectingTextureType = type;
        return this;
    }

    public RechiseledBlockBuilder translation(String translation) {
        this.translation = translation;
        return this;
    }

    public RechiseledBlockType build() {
        BlockProperties properties = this.properties.get();
        this.propertiesConfigurers.forEach(consumer -> consumer.accept(properties));
        RegistrationHandler handler = RegistrationHandler.get((String)this.namespace);
        Holder regularBlockHolder = new Holder();
        Holder connectingBlockHolder = new Holder();
        if (this.hasRegularVariant) {
            handler.registerBlock(this.identifier, () -> {
                regularBlockHolder.set((Object)new RechiseledBlock(false, properties));
                return (Block)regularBlockHolder.get();
            });
        }
        if (this.hasConnectingVariant) {
            handler.registerBlock(this.identifier + "_connecting", () -> {
                connectingBlockHolder.set((Object)new RechiseledBlock(true, properties));
                return (Block)connectingBlockHolder.get();
            });
        }
        Holder regularItemHolder = new Holder();
        Holder connectingItemHolder = new Holder();
        if (this.hasRegularVariant) {
            handler.registerItem(this.identifier, () -> {
                regularItemHolder.set((Object)new BaseBlockItem((Block)regularBlockHolder.get(), ItemProperties.create().group(this.itemGroup)));
                return (Item)regularItemHolder.get();
            });
        }
        if (this.hasConnectingVariant) {
            handler.registerItem(this.identifier + "_connecting", () -> {
                connectingItemHolder.set((Object)new BaseBlockItem((Block)connectingBlockHolder.get(), ItemProperties.create().group(this.itemGroup)));
                return (Item)connectingItemHolder.get();
            });
        }
        if (this.hasRegularVariant) {
            RechiseledBlockStateGenerator.addBlock(this.specification, () -> ((Holder)regularBlockHolder).get());
            RechiseledBlockTagsGenerator.addBlockTags(() -> ((Holder)regularBlockHolder).get(), this.tags);
            if (this.tagsFromBlock != null) {
                RechiseledBlockTagsGenerator.addBlockTagsFromOtherBlock(() -> ((Holder)regularBlockHolder).get(), this.tagsFromBlock);
            }
            RechiseledConnectingBlockModelProvider.addBlock(() -> ((Holder)regularBlockHolder).get(), this.specification, this.regularTextureType, new ResourceLocation(this.namespace, "block/" + this.identifier));
            RechiseledLanguageGenerator.addBlockTranslation(() -> ((Holder)regularBlockHolder).get(), this.translation);
            RechiseledLootTableGenerator.addDropSelfBlock(() -> ((Holder)regularBlockHolder).get());
        }
        if (this.hasConnectingVariant) {
            RechiseledBlockStateGenerator.addBlock(this.specification, () -> ((Holder)connectingBlockHolder).get());
            RechiseledBlockTagsGenerator.addBlockTags(() -> ((Holder)connectingBlockHolder).get(), this.tags);
            if (this.tagsFromBlock != null) {
                RechiseledBlockTagsGenerator.addBlockTagsFromOtherBlock(() -> ((Holder)connectingBlockHolder).get(), this.tagsFromBlock);
            }
            RechiseledConnectingBlockModelProvider.addBlock(() -> ((Holder)connectingBlockHolder).get(), this.specification, this.connectingTextureType, new ResourceLocation(this.namespace, "block/" + this.identifier));
            RechiseledLanguageGenerator.addBlockTranslation(() -> ((Holder)connectingBlockHolder).get(), this.translation);
            RechiseledLootTableGenerator.addDropSelfBlock(() -> ((Holder)connectingBlockHolder).get());
        }
        for (ResourceLocation recipe : this.recipes) {
            RechiseledChiselingRecipeProvider.addRecipeEntry(recipe, this.hasRegularVariant ? () -> ((Holder)regularItemHolder).get() : () -> this.customRegularVariant == null ? null : this.customRegularVariant.get().m_5456_(), this.hasConnectingVariant ? () -> ((Holder)connectingItemHolder).get() : () -> this.customConnectingVariant == null ? null : this.customConnectingVariant.get().m_5456_());
        }
        return new RechiseledBlockType(new ResourceLocation(this.namespace, this.identifier), this.hasRegularVariant ? () -> ((Holder)regularBlockHolder).get() : this.customRegularVariant, this.hasConnectingVariant ? () -> ((Holder)connectingBlockHolder).get() : this.customConnectingVariant, this.hasRegularVariant ? () -> ((Holder)regularItemHolder).get() : (this.customRegularVariant == null ? null : () -> this.customRegularVariant.get().m_5456_()), this.hasConnectingVariant ? () -> ((Holder)connectingItemHolder).get() : (this.customConnectingVariant == null ? null : () -> this.customConnectingVariant.get().m_5456_()));
    }
}

